<?php
/**
 * Plugin Name: EasyUpsell
 * Description: Add pruducts to checkout page, like upsell products.
 * Version: 1.1.6
 * Author: Anna Nicole Kucerova --  See also: <a href="https://nicoledigital.cz" target="_blank">NicoleDigital Network</a> - Zlepšete výkon vašeho webu See also: <a href="https://www.nicoledigital.cz/novyprojekt/" target="_blank">Eshop strugle help</a>
 */

if ( ! defined( 'ABSPATH' ) ) exit;

// ====== ADMIN MENU ======
add_action('admin_menu', function() {
    add_menu_page(
        'EasyUpSell',
        'EasyUpSell',
        'manage_options',
        'easyupsell',
        'easyupsell_settings_page',
        'dashicons-cart'
    );
});

// ====== SETTINGS PAGE ======
function easyupsell_settings_page() {
    if (isset($_POST['easyupsell_products'])) {
        update_option('easyupsell_products', array_slice(array_map('intval', $_POST['easyupsell_products']), 0, 3));
        echo '<div class="updated"><p>Nastavení uloženo.</p></div>';
    }

    $selected = get_option('easyupsell_products', []);
    ?>
    <div class="wrap">
        <h1>EasyUpSell – Nastavení</h1>
        <form method="post">
            <p>Vyberte až 3 produkty, které se mají zobrazovat jako upsell v pokladně:</p>
            <?php
            $args = array(
                'post_type'      => 'product',
                'posts_per_page' => -1,
                'post_status'    => 'publish',
                'orderby'        => 'title',
                'order'          => 'ASC'
            );
            $products = get_posts($args);
            foreach ($products as $p) {
                $checked = in_array($p->ID, $selected) ? 'checked' : '';
                echo '<label style="display:block;margin-bottom:4px;">';
                echo '<input type="checkbox" name="easyupsell_products[]" value="' . esc_attr($p->ID) . '" ' . $checked . '> ';
                echo esc_html($p->post_title);
                echo '</label>';
            }
            ?>
            <p><input type="submit" class="button-primary" value="Uložit"></p>
        </form>
    </div>
    <?php
}

// ====== FRONTEND (CHECKOUT) ======
add_action('woocommerce_before_checkout_form', 'easyupsell_show_products', 5);

function easyupsell_show_products() {
    if ( ! function_exists('is_checkout') || ! is_checkout() || is_cart() ) return;

    $products = get_option('easyupsell_products', []);
    if (empty($products)) return;

    echo '<div class="easyupsell-box" style="border:2px solid #ddd;padding:15px;margin:20px 0;background:#f9f9f9;border-radius:6px;">';
    echo '<h4 style="margin-top:0;">"Zákazníci často přidávají k nákupu tyto produkty...</h4>';
    echo '<div class="easyupsell-products" style="display:flex;gap:20px;flex-wrap:wrap;">';

    foreach ($products as $id) {
        $product = wc_get_product($id);
        if (!$product) continue;

        echo '<div class="easyupsell-item" style="text-align:center;border:1px solid #eee;padding:10px;background:#fff;flex:1;min-width:200px;border-radius:4px;">';
        echo get_the_post_thumbnail($id, 'thumbnail', ['style'=>'max-width:100px;height:auto;margin:auto;display:block;']);
        echo '<h4 style="margin:10px 0 5px;">' . esc_html($product->get_name()) . '</h4>';
        echo '<p style="font-weight:bold;margin:5px 0;">' . $product->get_price_html() . '</p>';
        echo '<a href="' . esc_url( wc_get_cart_url() . '?add-to-cart=' . $id ) . '" class="button">Přidat do košíku</a>';
        echo '</div>';
    }

    echo '</div></div>';
}
